#region References

using System;
using System.Data;
using System.Data.SqlClient;
using System.Reflection;
using System.Collections;
using gov.va.med.vbecs.ExceptionManagement;

using gov.va.med.vbecs.Common;

using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;

#endregion

namespace gov.va.med.vbecs.DAL
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Martin Tsotchev</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>1/27/2004</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	///	Implements data persistence logic for blood units. 
	///	Allows read and modify blood unit data in the VBECS database. 
	///</summary>	
    
	#endregion

	public class BloodUnitInactivate
	{
		#region Static Methods

		///<Developers>
		///	<Developer>Martin Tsotchev</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/27/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3746"> 
		///		<ExpectedInput>Valid Blood Unit GUID, comment, division code, last update date, last update user, last update function and row version</ExpectedInput>
		///		<ExpectedOutput>None</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3747"> 
		///		<ExpectedInput>Invalid Blood Unit GUID, comment, division code, last update date, last update user, last update function or row version</ExpectedInput>
		///		<ExpectedOutput>DataAccessLayerException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Inactivates a blood unit and its related information
		/// </summary>
		/// <param name="dtBloodUnit">Blood unit being inactivated.</param>
		/// <param name="dtBloodUnitMedia">Blood unit media of the blood unit</param>
		/// <param name="dtBloodUnitAntigen">Table of antigens that belong to the blood unit.</param>
		/// <param name="dtWorkloadEvent">Workload event data</param>
		public static bool InactivateUnit
		(
			System.Data.DataTable dtBloodUnit,
			System.Data.DataTable dtBloodUnitMedia,
			System.Data.DataTable dtBloodUnitAntigen,
			System.Data.DataTable dtWorkloadEvent
		)
		{
			ArrayList dtArray = new ArrayList();
			ArrayList spArray = new ArrayList();
			//
			dtArray.Add(dtBloodUnit);
			dtArray.Add(dtBloodUnitMedia);
			dtArray.Add(dtBloodUnitAntigen);
			dtArray.Add(dtWorkloadEvent);
			//
			spArray.Add(STOREDPROC.UpdateBloodUnit.StoredProcName);
			spArray.Add(STOREDPROC.UpdateBloodUnitMedia.StoredProcName);
			spArray.Add(STOREDPROC.InactivateBloodUnitAntigen.StoredProcName);
			spArray.Add(STOREDPROC.InsertWorkloadEvents.StoredProcName);
			//
			return (((new StoredProcedure()).TransactionalGetValue(spArray, dtArray)) == 0);
		}

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>06/30/2005</CreationDate>
		///<TestCases>
		///
		///<Case type="0" testid ="7342"> 
		///		<ExpectedInput>DataTables</ExpectedInput>
		///		<ExpectedOutput>true</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7343"> 
		///		<ExpectedInput>DataTables with invalid data</ExpectedInput>
		///		<ExpectedOutput>RowVersionException</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Inactivates a blood unit and its related information
		/// Overloaded: used to inactivate a shipment record when 
		/// a pool/split unit is inactivated
		/// </summary>
		/// <param name="dtBloodUnit">Blood unit being inactivated.</param>
		/// <param name="dtBloodUnitMedia">Blood unit media of the blood unit</param>
		/// <param name="dtBloodUnitAntigen">Table of antigens that belong to the blood unit.</param>
		/// <param name="dtBloodUnitShipment">Blood Unit Shipment data</param>
		/// <param name="dtWorkloadEvent">Workload event data</param>
		public static bool InactivateUnit
		(
			System.Data.DataTable dtBloodUnit,
			System.Data.DataTable dtBloodUnitMedia,
			System.Data.DataTable dtBloodUnitAntigen,
			System.Data.DataTable dtBloodUnitShipment,
			System.Data.DataTable dtWorkloadEvent
		)
		{
			ArrayList dtArray = new ArrayList();
			ArrayList spArray = new ArrayList();
			//
			dtArray.Add(dtBloodUnit);
			dtArray.Add(dtBloodUnitMedia);
			dtArray.Add(dtBloodUnitAntigen);
			dtArray.Add(dtBloodUnitShipment);
			dtArray.Add(dtWorkloadEvent);
			//
			spArray.Add(STOREDPROC.UpdateBloodUnit.StoredProcName);
			spArray.Add(STOREDPROC.UpdateBloodUnitMedia.StoredProcName);
			spArray.Add(STOREDPROC.InactivateBloodUnitAntigen.StoredProcName);
			spArray.Add(STOREDPROC.InactivateBloodUnitShipment.StoredProcName);
			spArray.Add(STOREDPROC.InsertWorkloadEvents.StoredProcName);
			//
			return (((new StoredProcedure()).TransactionalGetValue(spArray, dtArray)) == 0);
		}

		#endregion
	}
}


